- Source
	- [[AutoCAD DevBlog]]: [dxf-files-binary-chunk-interpretation.html](http://adndevblog.typepad.com/autocad/2013/02/dxf-files-binary-chunk-interpretation.html)
	- ((6551c8c7-b9c9-441d-b28c-97e46cdbdc2e))
	- Collection: [[DXF Internals]]
- ## Issue
	- I need to know how to interpret the binary data enclosed in AutoCAD DXF files, most importantly:
		- the block preview bitmap,
		- the drawing thumbnail bitmap,
		- any embedded OLE object,
		- the proxy object graphics.
- ## Solution
	- Binary Data enclosed in DXF file are stored by blocks of 256 bytes maximum under DXF code 310 (i.e. 'kDxfBinaryChunk').
	- The number of blocks is not limited, but sometimes the binary chunk blocks are preceded by a DXF code 92 (of type int) which indicates the number of blocks to proceed. All binary chunk formats depend on the object being saved.
	- For example the drawing thumbnail bitmap is a DIB file. For the embedded OLE object, it depends on the OLE object itself, etc.
	-
	- ### ACIS
		- the binary chunk blocks contain the encrypted DXF output of the ACIS object. There is a utility available at the following URL, which can help to decode that block(s)
		- <http://autocad.xarch.at/stdlib/html/samp5v51.htm>
		- Block preview image bitmap and Drawing thumbnail bitmap
			- the binary chunk blocks are a memory copy of a BITMAPINFO structure, with bitmap bits.
			-
	- ### Embedded OLE object: it depends on the OLE Item version
		- #### OLE1
			- it is a memory copy of MFC COleClientItem object version OLE1
		- #### OLE2:
			- Signature: 0x5580 | kPaperSpace (kPaperSpace = 0x01)
			- AcGePoint3d() upLeft
			- AcGePoint3d() upRight
			- AcGePoint3d() bottomRight
			- AcGePoint3d() bottomLeft
			- long extents =0 // always
			- long tilemode (=0, or =1) (r13 compatibility)
			- then the output of COleclientItem::Serialize() method
			-
	- ### DXF ENTITY section binary chunk interpretation
		- sometimes the ENTITY section of an object contains some binary chunk information block(s).
		- This section appears for any object which is not part of the AutoCAD core (i.e. custom entities, or AutoCAD entities defined in ARX/DBX modules).
		- It is always preceded by a DXF code 92 which indicates the length of the binary chunk.
		- And the binary chunk contains the proxy graphic generated by the entity, when its `saveAs()` method was called by AutoCAD.
		- Depending of the settings of AutoCAD (i.e. Proxy Graphic Never Saved), and the presence of the ARX/DBX module when the DXFOUT operation occurred, the binary chunk can contain
			- a bounding box with class name and logical application name
			- the last known entity graphic description.
			-
	- ### Proxy graphics binary chunk
		- this one contains the output of the AcGiWorldDraw/AcGiViewportDraw vector collector classes which were called upon DXFOUT.
		- You need to interpret those information to rebuild the saved graphic...
		- [[Proxy Graphic Binary Chunk]]
			- describes how to interpret information contained in these blocks.